//Experiment-2
// windows Vista - 32-Bit
//Scilab - 5.5.2


//Aim : A SCILAB program to evaluate performance of short transmission line using graphical method


clear all;
clc;
// This program calculates the percentage regulation of a short transmission line 
// It is assumed that the receiving end voltage Vr and magnitude of current Ir are constant 
Vr = 220e3; // receiving end voltage
R = 33.5;	// input line resistance
X = 138;	// line reactance
Z = R + X*%i;	// line impedance
Irmag = 164.02; // receiving end current magnitude
// This Irmag is assumed to be constant. This will change the angle of 
// phasor of Ir in the vector diagram over the range of pf set in following line 
			pf = 1:-0.001:0.5;	// power factor			
			Irang = acos(pf);				
			Ir = Irmag * exp(-%i*Irang);	// For lagging power factor			
			Vs = (Vr/sqrt(3))+ Ir*Z;	// sqrt(3) is used here as we need to do a per phase analysis			
			VrNL = abs(Vs);				
VrFL = abs(Vr/sqrt(3));
per_vol_regu= ((VrNL-VrFL)/VrFL)*100; 
plot(pf,per_vol_regu,'-');
xlabel('power factor') 
ylabel('voltage regulation') 
title('Graph of power factor v/s voltage regulation')

// For leading power factor range, angle should be positive So,

Ir = Irmag * exp(%i*Irang);

Vs = (Vr/sqrt(3))+ Ir*Z;

VrNL = abs(Vs); // absolute value of Vs

VrFL = abs(Vr/sqrt(3));	//abs value of Vr per phase

per_vol_regu= ((VrNL-VrFL)/VrFL)*100; 
plot(pf,per_vol_regu,'r*');
legend('Lagging Power Factor','Leading Power Factor')
//gtext('Vreg vs lagging pf') 
//gtext('Vreg vs leading pf')
